#Number text output by Dale Swanson November 11th 2007
#list all the files of a certain type, made for finding html files, but should work for anything

#!/usr/bin/perl
usestrict;
usewarnings;

use Cwd;

my $filetype = ".htm"; # this is what the program will match, change it to whatever you want to search for
my $outname = "output"; #output file name, change it to whatever you want
my $outext = ".htm"; #file extension of output file
my @allfiles; #stores all the files in the directory
my $file; #used to access each file in the allfiles array
my @dirs; #array of all the directories
my $dirname; #used to store the directory name of a directory
my $dircount; #count of all the directories, not currently used
my @htmlfiles; #array of all the files that match the file type
my $filename; #used to store the file name of a file matching the file type
my $htmlcount; #count of the matching files, not currently used
my $dir; #the name of the directory being worked with
my $startdir; #name of the directory the program is ran from
my $debug = 0; #debug mode, set to 1 to get lot's of output
my $mode = 1; #output mode, 0 - flat text file, 1 - html file with links, 2 - html file img tags

system("CLS") if ($debug);
(print "\n") if ($debug);

$outname = $outname . $filetype . $outext; #puts the filetype in the output file name, if you are searching for htm, and the output file is output.txt, you'll get output.htm.txt

$dir = cwd(); #starting directory
$startdir = $dir . "/"; #add the slash since it's not there by default

sub listfiles
{# goes through all the files in the current directory, finds the other directories, and the files matching filetype
	(print "\ndir - $dir") if ($debug);
	opendir THISDIR, $dir or die "Can't open directory: $!";
	@allfiles = grep !/^\.\.?$/, readdir THISDIR; #gets all the files in this directory, strips . and ..
	closedir THISDIR;
	(print "\nALL FILES:\n@allfiles\n") if ($debug);
	
	foreach $file (@allfiles)
	{# go through each file, check to see if it's a directory or the filetype we want
		(print "\nTest File - $file") if ($debug);
		if (-d $dir . "/" . $file )
		{# if it's a directory
			(print "\nList DIR - $file") if ($debug);
			$dirs[$dircount] = $dir . "/" . $file; #adds the directory's name to the array of directories
			$dircount++;
		}
		if ($file =~ /$filetype/i)
		{# if the file type was found 
			(print "\nList HTML - $file") if ($debug);
			$htmlfiles[$htmlcount] = $dir . "/" . $file; #adds the file's name to the array of files, uses the full path
			$htmlcount++;
		}
	}
	(print "\n***\nAll Directories:\n@dirs\n") if ($debug);
}
&listfiles; #run the sub for the first time

foreach $dirname (@dirs)
{# go through all the directories, and run the main sub, to find more files
	$dir = $dirname; 
	(print "\ndirname - $dirname, dir - $dir") if ($debug);
	&listfiles;
}

open(ofile, ">$outname"); #output file name
(print ofile ("<html><body>\n")) if ($mode); #put some basic html, not really needed

foreach $filename (@htmlfiles)
{# go through all the files and output them to the file
	$filename =~ s/$startdir//; #strip the file path of the part prior to the starting directory, will give paths like /test/fun/file.html rather than C:/site/test/fun/file.htm
	(print "\nfilecount - $htmlcount") if ($debug);
	(print "\nLoop HTML - $filename") if ($debug);
	if ($mode == 1)
	{#output mode 1, html links
		$filename = "<br><a href=\"" . $filename . "\">" . $filename . "</a>"; #adds the html to make it a link
	}
	elsif ($mode == 2)
	{#output mode 2, html img tags
		$filename = "<br><img src=\"" . $filename . "\">"; #adds the html to make it a img
	}
	(print "\Out HTML - $filename") if ($debug);
	print ofile ("\n");
	print ofile ($filename); #records it to the file
}
(print ofile ("\n</body></html>")) if ($mode); #some closing html
